function errors = pv01_weighted_tranche_mispricing(CDX, start_date_num, end_date_num, maturities)
% --------------------------------------------------------------------------------------------------
% Calculate capital weighted (signed) tranche pricing error. Used for calculateing the liquidity
% premium, value of modief-restructuring protection, and cheapest-to-deliver option
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure (see 'all_steps_in_a_row.m')
% start_date_num    ... datenum of start date
% end_date_num      ... datenum of end date
% maturities        ... indicator vector, for which maturities to calculate error
% --------------------------------------------------------------------------------------------------
% sample call: pv01_weighted_tranche_mispricing(cdx_mor, datenum('12/05/2005'), datenum('12/05/2005'))
% --------------------------------------------------------------------------------------------------

% Calculate pricing error for each maturitiy
errors = {};
for i=1:length(CDX.dates)
    if (maturities(i) == 0)
        continue;
    end
    
    % Determine relevant date range
    start_pos = find(CDX.dates{i} >= start_date_num, 1, 'first');
    end_pos = find(CDX.dates{i} <= end_date_num, 1, 'last');
    used_range = start_pos:end_pos;

    % Extract model_implied and market prices of tranches
    market_price = CDX.tranche_market_price_mid{i}(used_range,:);
    market_upfront = CDX.tranche_market_upfront_mid{i}(used_range,:);
    model_price = CDX.tranche_model_price{i}(used_range,:);
    model_upfront = CDX.tranche_model_upfront{i}(used_range,:);    
    price_error = market_price - model_price;
    upfront_error = market_upfront - model_upfront;
    
    % Calculate overpricing (in basis points/index notional)
    errors{i} = -upfront_error(:,1) * CDX.cut_offs(1) * 1e4 + ...
                -sum(price_error(:,2:end) .* CDX.PV01{i}(used_range,2:end) .* repmat(diff(CDX.cut_offs), length(used_range), 1), 2);
end

